class SharedObject {
  boolean isInitialised;        // false by default
}

class MyThread implements Runnable {
  private SharedObject myObject;
  private Thread myParent;

  public MyThread(SharedObject anObject) {
    myObject = anObject;
    myParent = Thread.currentThread();
  }

  public void run() {           // This is the main body of the thread
    Thread myself = Thread.currentThread();
    System.err.println(myself.getName() + " Started");
    synchronized(myObject) {
      while (! myObject.isInitialised) {
        try {
          myObject.wait();        // Wait for initialisation to end.
        } catch (InterruptedException e) { }
      }
    }
    System.err.println(myself.getName() + " my priority is " +
                       myself.getPriority());
    System.err.println(myself.getName() + " My parent is " +
                       myParent.getName());
    return;
  }
}

class Initialise {
  public static void main(String[] argv) {
    Thread.currentThread().setName("main:");
    SharedObject sharedObject = new SharedObject();
    MyThread threadOne = new MyThread(sharedObject);
    MyThread threadTwo = new MyThread(sharedObject);
    ThreadGroup myGroup = Thread.currentThread().getThreadGroup();
    long stackSize = 1L;        // Just 1 Byte...
    Thread tOne = new Thread(myGroup, (Runnable) threadOne,
                             "\tthreadOne:", stackSize);
    Thread tTwo = new Thread(myGroup, (Runnable) threadTwo,
                             "\t\tthreadTwo:", stackSize);
    tOne.setPriority(java.lang.Thread.MAX_PRIORITY - 0);
    tTwo.setPriority(java.lang.Thread.MAX_PRIORITY - 1);
    tOne.start();
    tTwo.start();
    System.err.println(Thread.currentThread().getName() +
                       " Finished initialisation - my priority is " +
                       Thread.currentThread().getPriority());
    synchronized(sharedObject) {// End of initialisation.
      sharedObject.isInitialised = true;
      sharedObject.notifyAll();
    }
    try {
      tOne.join();
    } catch (InterruptedException ie) {
      System.err.println("Interrupted join on threadOne: " + ie);
    }
    try {
      tTwo.join();
    } catch (InterruptedException ie) {
      System.err.println("Interrupted join on threadTwo: " + ie);
    }
  }
}
