/*

  RTSJ_HOME=/import/linux/soft/src/rtsj-ri/refimp-1.0
  javac -bootclasspath ${RTSJ_HOME}/lib/foundation.jar rtsj-ex.java

  (cd ${RTSJ_HOME}/pthreadrt ; test -f libpthreadrt.so || ln -s libpthreadrt.so.2.0 libpthreadrt.so)

  LD_LIBRARY_PATH=${RTSJ_HOME}/pthreadrt:${LD_LIBRARY_PATH}

  I don't have an EDF scheduler but I can *fake* one

  ${RTSJ_HOME}/bin/tjvm \
    -Xbootclasspath=${RTSJ_HOME}/lib/foundation.jar \
    -Djava.class.path=`pwd` \
    -Djavax.realtime.scheduler.EDF=javax.realtime.PriorityScheduler \
    SchedExample

  One would have normally run this as:

  ${RTSJ_HOME}/bin/tjvm \
    -Xbootclasspath=${RTSJ_HOME}/lib/foundation.jar \
    -Djava.class.path=`pwd` \
    SchedExample

*/

import java.lang.*;
import java.util.*;
import javax.realtime.*;

class MyRunnable implements Runnable {
  public static void remaining(String s, MemoryArea m) {
    System.err.println("\t"+s+":"+m
                       +"|Size="+m.size()
                       +"|Left="+m.memoryRemaining()
                       +"|");
  }

  public void run() {
    RealtimeThread I = null;
    try {
      I = (RealtimeThread) Thread.currentThread();
    } catch (ClassCastException e) {
      System.err.println(e);
    }

    System.err.println(I);

    MemoryArea memArea = null;

    int stackDepth = javax.realtime.RealtimeThread.getMemoryAreaStackDepth();

    switch (stackDepth) {
     case 3:
      memArea = javax.realtime.RealtimeThread.getOuterMemoryArea(stackDepth-3);
      remaining("Heap   ",memArea);
      /* fall through */
     case 2:
      memArea = javax.realtime.RealtimeThread.getOuterMemoryArea(stackDepth-2);
      remaining("oldMem ", memArea);
      /* fall through */
     case 1:
      memArea = javax.realtime.RealtimeThread.getOuterMemoryArea(stackDepth-1);
      remaining("newMem ", memArea);

      System.err.print('\n');
    }
  }
}

class SchedExample {

  static protected LTMemory anewMem = null;
  static protected Runnable anewRun = null;

  public static Scheduler findSched(String policy) {
   String className = System.getProperty("javax.realtime.scheduler."+policy);
   Class clazz;
   try {
     if (null != className && null != (clazz = Class.forName(className))) {
       System.err.println("findSched: Found " + policy);
       return (Scheduler) clazz.getMethod("instance",null).invoke(null,null);
     } else {
       System.err.println("findSched: Could not find " + policy);
     }
   } catch (Exception e) {
     System.err.println("findSched: " + e);
   }
   return null;
  }

  public static void main(String[] args) throws Exception {
    Scheduler sched = findSched("EDF");
    if (null != sched) {
      System.err.println("main: Found EDF scheduling policy");
    } else {
      System.err.println("main: Could not find EDF scheduling policy"
                         + " - Using default");
      // What are the system properties anyway?
      System.getProperties().list(System.err);
      System.err.println("-- end of listing properties --");
      sched = javax.realtime.Scheduler.getDefaultScheduler();
    }
    System.err.println("main: Your scheduling policy's *real* name is "
                       + sched.getPolicyName());

    AsyncEventHandler missHandler = new AsyncEventHandler(new
                                                          Runnable ()
      {
        public void run() {
          System.err.println("Missed a period - exiting");
          System.exit(1);
        }
      }
                                                          );

    PeriodicParameters pp = new
      PeriodicParameters(
                         new RelativeTime(0,0),//when released
                         new RelativeTime(400, 0),  // period
                         new RelativeTime(30, 0),      // cost
                         new RelativeTime(60, 0),  // deadline
                         null,           // no Overrun Handler
                         missHandler);   // the Miss Period Handler
    ImportanceParameters prio = new
      ImportanceParameters(3, 3);
    MemoryParameters mp = new
      MemoryParameters(MemoryParameters.NO_MAX,MemoryParameters.NO_MAX);

    final LTMemory oldMem = new LTMemory(6*1024, 6*1024);

    ProcessingGroupParameters gp = null;

    final Class argTypes[] = {long.class,// this is the type of a primitive long
                              long.class};
    // Find the constructor of the LTMemory class which takes two longs as
    // arguments.
    final java.lang.reflect.Constructor ltmemconstructor =
        LTMemory.class.getConstructor(argTypes);
    // You could also have used the Class.forName(String) to get the class:
//  final java.lang.reflect.Constructor ltmemconstructor =
//      Class.forName("javax.realtime.LTMemory").getConstructor(argTypes);

    // I need an array of *Objects* to pass to the constructor invocation,
    // so I must use Long, instead of long.
    final Object minMax[] = { new Long(4*1024L), new Long(4*1024L) };

    RealtimeThread rt = new
      RealtimeThread(prio, pp, mp, oldMem, gp, new Runnable ()
      {
         public void comp(final String s1, final String s2) {
           RealtimeThread I = null;
           try {
             I = (RealtimeThread) Thread.currentThread();
           } catch (ClassCastException e) {
             System.err.println(e);
           }
           if (I.getCurrentMemoryArea() != oldMem)
             System.err.println("Should never happen");

           try {
             // Get a new instance using the constructor & args you have
             // precalculated.
             if (null == anewMem)
               anewMem = (LTMemory)oldMem.newInstance(ltmemconstructor, minMax);
           }
           catch (java.lang.IllegalAccessException e){
             System.err.println(e);
             System.exit(20);
           }
           catch (java.lang.InstantiationException e){
             System.err.println(e);
             System.exit(21);
           }
           catch (Exception e) {
             System.err.println(e);
             System.exit(22);
           }
           final LTMemory newMem = anewMem;

           // newRun *runs in* newMem, but is *allocated* on oldMem.
           try {
             // Get a new instance using the constructor & args you have
             // precalculated.
             if (null == anewRun)
               anewRun = (MyRunnable) oldMem.newInstance(MyRunnable.class);
           }
           catch (java.lang.IllegalAccessException e){
             System.err.println(e);
             System.exit(30);
           }
           catch (java.lang.InstantiationException e){
             System.err.println(e);
             System.exit(31);
           }
           catch (Exception e) {
             System.err.println(e);
             System.exit(32);
           }
           final Runnable newRun = anewRun;

           try {
             newMem.joinAndEnter(newRun);
           } catch (InterruptedException ie){
             System.err.println(ie);
           }
         }

         public void run() {
           try {
             RealtimeThread I =
                  (RealtimeThread) Thread.currentThread();
             MemoryArea myMem =
                  I.getCurrentMemoryArea();
             if (oldMem != myMem)
               System.exit(10);

             String first = new String(I + ": Started");
             String next = new String(I + ": Running");

             System.err.println(I+":");
             MyRunnable.remaining("oldMem ", oldMem);
             System.err.print('\n');

             comp("1-Not using the right scope", first);

             java.lang.Runtime.getRuntime().traceInstructions(true);
             java.lang.Runtime.getRuntime().traceMethodCalls(true);

             do {

               comp("2-Not using the right scope", next);

             } while(I.waitForNextPeriod());
           } catch (ClassCastException e) {
             System.err.println(e);
           }
         }
      }
                     );

    rt.setScheduler(sched);
    if (!rt.getScheduler().isFeasible())
      throw new Exception("Not feasible");

    System.err.println("\n\t\t\t\t\tmain is : "+Thread.currentThread()+'\n');

    rt.start();                 // Release the thread
  }
}

