class SharedObject {
  boolean isInitialised;        // false by default
}

class MyThread extends Thread {
  private SharedObject myObject;
  private Thread myParent;

  public MyThread(SharedObject anObject) {
    myObject = anObject;
    myParent = Thread.currentThread();
  }

  public void run() {
    // This is the main body of the thread
    System.err.println(this.getName() + " Started");
    synchronized(myObject) {
      while (! myObject.isInitialised) {
        try {
          myObject.wait();        // Wait for initialisation to end.
        } catch (InterruptedException e) { }
      }
    }
    System.err.println(this.getName() + " my priority is " +
                       this.getPriority());
    System.err.println(this.getName() + " My parent is " +
                       myParent.getName());
    return;
  }
}

class Initialise {
  public static void main(String[] argv) {
    Thread.currentThread().setName("main:");
    SharedObject sharedObject = new SharedObject();
    MyThread threadOne = new MyThread(sharedObject);
    MyThread threadTwo = new MyThread(sharedObject);
    threadOne.setName("\tthreadOne:");
    threadOne.setPriority(java.lang.Thread.MAX_PRIORITY - 0);
    threadTwo.setName("\t\tthreadTwo:");
    threadTwo.setPriority(java.lang.Thread.MAX_PRIORITY - 1);
    threadOne.start();
    threadTwo.start();
    System.err.println(Thread.currentThread().getName() +
                       " Finished initialisation - my priority is " +
                       Thread.currentThread().getPriority());
    synchronized(sharedObject) {// End of initialisation.
      sharedObject.isInitialised = true;
      sharedObject.notifyAll();
    }
    try {
      threadOne.join();
    } catch (InterruptedException ie) {
      System.err.println("Interrupted join on threadOne: " + ie);
    }
    try {
      threadTwo.join();
    } catch (InterruptedException ie) {
      System.err.println("Interrupted join on threadTwo: " + ie);
    }
  }
}
